/* 
 *  BinDataTabBase.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DataI;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;

public class BinDataTabBase {

    protected static final char[] HEXARRAY = "0123456789ABCDEF".toCharArray();
    private static final Logger LOG = Logger.getLogger(BinDataTabBase.class);

    protected final Tab tab;
    protected final TextArea dataEditor;
    private String blankdata;
    protected final BorderPane pane;

    public BinDataTabBase(String blank) {
        dataEditor = new TextArea();
        dataEditor.getStyleClass().add("dataEditor");
        blankdata = blank;
        dataEditor.setText(blankdata);
        dataEditor.setEditable(false);
        tab = new Tab();
        tab.setText("Binary");
        tab.setClosable(false);

        tab.setContent(dataEditor);
        tab.setDisable(true);

        pane = new BorderPane();
        pane.setCenter(dataEditor);
        tab.setContent(pane);
    }

    public Tab getTab() {
        return tab;
    }

    void update(InteractionDataI data) {
        boolean disable = !data.canGetData();
        this.dataEditor.setDisable(disable);
        this.tab.setDisable(disable);

        DataI dataInstance = data.getData();
        if (dataInstance != null) {
            switch (dataInstance.getFormat()) {
                case BIN:
                    this.tab.setDisable(false);
                    dataEditor.setText(BinDataTab.bytesToHex(dataInstance.getBinaryData()));
                    break;
                case KVP:
                    this.tab.setDisable(true);
                    break;
                case STR:
                    this.tab.setDisable(true);
                    break;
                case UNKNOWN:
                    dataEditor.setText(getBlankdata());
                    break;
            }
        } else {
            dataEditor.setText(getBlankdata());
        }
    }

    public static boolean isStringHex(String toCheck) {
        String methodName = "isStringHex() ";
        //Check for multiple of 2 as we need 2 hex chars to match each byte
        if (toCheck.length() % 2 != 0) {
            LOG.error(methodName + "need 2 hex chars to match each byte ");
            return false;
        }
        for (int i = 0; i < toCheck.length(); i++) {
            boolean validChar = false;
            for (int j = 0; j < HEXARRAY.length; j++) {
                if (toCheck.charAt(i) == HEXARRAY[j]) {
                    validChar = true;
                    break;
                }
            }
            //Found at least one invalid char
            if (validChar == false) {
                LOG.error(methodName + "Found at least one invalid char:" + toCheck.charAt(i));
                return false;
            }
        }
        return true;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; j++) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEXARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEXARRAY[v & 0x0F];
        }
        return new String(hexChars);
    }

    public String getBlankdata() {
        return blankdata;
    }
}
